/*------------------------------------------------------------------------------*
 * File Name: Cellular Automator example for Origin C							*
 *------------------------------------------------------------------------------*/
 
#include <origin.h>

//**********************************
// to implement a command 
// ca
// for a simple celluar automator program
// usage:
// 1. compile this file
// 2. close CodeBuilder for faster execution
// 3. create a new matrix
// 4. from script window, type ca and press enter
//**********************************

////////////////////////////////////////////////////////////////////////////////////
//static int temp[8] = {0,0,0,1,1,1,1,0}; // Rule 30
static int my_rules[8] = {0,0,0,1,1,0,1,0};

////////////////////////////////////////////////////////////////////////////////////
// our basic rule function
// we take all the 8 possible permutations for the three cells above the 
// current cell and we need to determine live (1) or die (0)
// and the determinations are stored in the my_rules array above
// 
// use static function to avoid being visible from LabTalk
static int rule(int left, int top, int right)
{
	if(left && top && right)
		return my_rules[0];
	
	if(left && top && !right)
		return my_rules[1];
	
	if(left && !top && right)
		return my_rules[2];
	
	if(left && !top && !right)
		return my_rules[3];
	
	if(!left && top && right)
		return my_rules[4];
	
	if(!left && top && !right)
		return my_rules[5];
	
	if(!left && !top && right)
		return my_rules[6];
	
	// for left=top=right=0
	return my_rules[7];
}

// this is our main function to be called from labtalk
void ca()
{
	MatrixLayer ml = Project.ActiveLayer();
	
	if(ml==NULL)
	{
		out_str("Must have matrix as active window");
		return;
	}
	
	ml.SetInternalData(FSI_BYTE);
	ml.SetNumCols(1000);
	ml.SetNumRows(500);
	
	Matrix<BYTE>	mat(ml);
	int		nCols = mat.GetNumCols();
	
	//---------
	// init 1st row of matrix to be all zero except 1 in the middle
	for(int ii = 0; ii < nCols; ii++)
	{
		mat[0][ii] = 0;
	}
	mat[0][nCols/2] = 1;
	//---------

	int	left,top,right;
	
	// start from 2nd row
	progressBox	show("calculating....");
	show.SetRange(1,mat.GetNumRows());
	
	for(int nR = 1, nRLast=0; nR < mat.GetNumRows(); nR++,nRLast ++)
	{
		if(!show.Set(nR))  // user click cancel
			break;

		for(int nC = 0; nC < nCols; nC++)
		{
			left = nC > 0? mat[nRLast][nC-1] : 0;
			top = mat[nRLast][nC];
			right = nC < nCols-1? mat[nRLast][nC+1] : 0;
			mat[nR][nC] = rule(left,top,right);
		}
	}
	ml.SetViewImage(TRUE);
	ml.LT_execute("Z1=0;Z2=1");// this is needed to set Z range to show bitmap as black and white
}

//----------------------------- EOF
